% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runAppx.R
\name{runAppx}
\alias{runAppx}
\title{runAppx}
\usage{
runAppx(example = "mini", x = NULL, ...)
}
\arguments{
\item{example}{character: name of the example to run, or NA to list the available examples}

\item{x}{data frame: data to pass to the app}

\item{...}{further parameter given to \code{\link[shiny:runExample]{shiny::runExample()}}}
}
\value{
invisibly the (modified) data set \code{x}
}
\description{
Runs an example Shiny app via \code{\link[shiny:runExample]{shiny::runExample()}}.
}
\details{
Note that for running a Shiny app more libraries might be necessary.
}
\examples{
# Example requires the use of a `shiny` app (See Vignette)
# List all available examples
runAppx(NA)

\dontrun{
# Run the "mini" example app
runAppx("mini")

# Run with a dataset passed to the app
check <- data.frame(a = 1:9)
runAppx("mini", x = check)

# Can also pass arguments to shiny::runExample
runAppx("mini", display.mode = "showcase")
}
}
