% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_quickmap_nb.R
\name{st_quickmap_nb}
\alias{st_quickmap_nb}
\title{Visualise a neighbourhood structure on a map}
\usage{
st_quickmap_nb(
  nbsf,
  linkcol = "dodgerblue",
  bordercol = "gray7",
  pointcol = "darkred",
  fillcol = "gray95",
  linksize = 0.2,
  bordersize = 0.1,
  pointsize = 0.8,
  title = NULL,
  subtitle = NULL,
  nodes = "point",
  numericsize = 5,
  numericcol = "black",
  concavehull = FALSE,
  hullratio = 0.8,
  hullcol = "darkgreen",
  hullsize = 0.5
)
}
\arguments{
\item{nbsf}{an `sf` dataframe with a neighbourhood column called "nb", such as the output of `st_bridges()`}

\item{linkcol}{colour of lines connecting neighbours.}

\item{bordercol}{colour of boundary lines between areas.}

\item{pointcol}{colour of centroid points if nodes are `"point"`.}

\item{fillcol}{fill of areas.}

\item{linksize}{linewidth of lines connecting neighbours.}

\item{bordersize}{linewidth of borders between areas.}

\item{pointsize}{size of centroid points if nodes are `"point"`.}

\item{title}{plot title.}

\item{subtitle}{plot subtitle.}

\item{nodes}{default `"point"`. Can also be `"numeric"`.}

\item{numericsize}{font size if nodes are `"numeric"`.}

\item{numericcol}{font colour if nodes are `"numeric"`.}

\item{concavehull}{default `FALSE`. Whether or not to show concave hulls.}

\item{hullratio}{value between 0 and 1. 1 returns the convex hulls, 0 maximally concave hulls.}

\item{hullcol}{colour of concave hull lines.}

\item{hullsize}{line width of concave hull lines.}
}
\value{
A `ggplot` showing areas and neighbourhood structure.
}
\description{
Visualise a neighbourhood structure on a map
}
\examples{
st_bridges(uk_election,"constituency_name") |>
st_quickmap_nb()
}
