% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpi0est.R
\name{fpi0est}
\alias{fpi0est}
\title{Estimate the functional proportion of null tests}
\usage{
fpi0est(
  p,
  z,
  pi0_model,
  indep_snps = NULL,
  lambda = seq(0.05, 0.9, 0.05),
  method = "gam",
  maxit = 1000,
  pi0.method.control = NULL,
  ...
)
}
\arguments{
\item{p}{A vector of p-values.}

\item{z}{A vector of informative variables}

\item{pi0_model}{Model formula corresponding to \code{z} for the functional proportion of truly null tests.}

\item{indep_snps}{A boolean vector (same size as p) specifying the set of independent tests. Default is NULL and all tests are treated independently.}

\item{lambda}{A vector of values between [0,1] to estimate the functional proportion of truly null tests.}

\item{method}{Either the "gam" (generalized additive model) or "glm" (generalized linear models) approach. Default is "gam".}

\item{maxit}{The maximum number of iterations for "glm" approach. Default is 1000.}

\item{pi0.method.control}{A user specified set of parameters for convergence for either "gam" or "glm". Default is NULL. See \code{\link[gam]{gam.control}} or \code{\link{glm.control}}.}

\item{\ldots}{Additional arguments passed to \code{\link[gam]{gam}} or \code{\link{glm}}.}
}
\value{
A list of object type "fpi0" containing:
\item{fpi0}{A table containing the functional proportion of truly null tests.}
\item{tableLambda}{Functional proportion of null tests at the lambda values}
\item{MISE}{MISE values.}
\item{lambda.hat}{The chosen lambda value.}
}
\description{
he function \code{\link{fpi0est}} estimates the functional proportion of null tests given
a set of informative variables.
}
\details{
This code extends the function from the fFDR package to handle
multiple informative variables and linkage disequilibrium.
}
\examples{
\donttest{
# import data
data(bmi)

# separate main p-values and conditioning p-values
p <- sumstats$bmi
z <- as.matrix(sumstats[, -1])

# apply pi0_model to create model
knots <- c(0.005, 0.01, 0.025, 0.05, 0.1)
fmod <- pi0_model(z, knots = knots)

# Estimate functional pi0
fpi0_out <- fpi0est(p, z = fmod$zt, pi0_model = fmod$fmod)
fpi0 <- fpi0_out$fpi0

# See relationship of BFP/cholesterol/triglycerides and fpi0
plot(fmod$zt$bfp, fpi0)
plot(fmod$zt$cholesterol, fpi0)
plot(fmod$zt$triglycerides, fpi0)
}
}
\seealso{
\code{\link{sffdr}}, \code{\link{plot.sffdr}}
}
\author{
Andrew J. Bass, David G. Robinson (author of original function)
}
\keyword{fpi0est}
