% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-VolumeFile.R
\name{VolumeFile}
\alias{VolumeFile}
\title{R6 Class representing a VolumeFile}
\description{
R6 Class representing a resource for managing VolumeFile objects.
}
\examples{

## ------------------------------------------------
## Method `VolumeFile$print`
## ------------------------------------------------

\dontrun{
# x is API response when volume file is requested
volume_file_object <- VolumeFile$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print volume file object
 volume_file_object$print()
}


## ------------------------------------------------
## Method `VolumeFile$reload`
## ------------------------------------------------

\dontrun{
# x is API response when volume file is requested
volume_file_object <- VolumeFile$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload volume file object
 volume_file_object$reload()
}


## ------------------------------------------------
## Method `VolumeFile$import`
## ------------------------------------------------

\dontrun{
# x is API response when volume file is requested
volume_file_object <- VolumeFile$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Import volume file object
 volume_file_object$import(destination_project = destination_project)
}

}
\section{Super class}{
\code{\link[sevenbridges2:Item]{sevenbridges2::Item}} -> \code{VolumeFile}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}

\item{\code{location}}{File location on the volume.}

\item{\code{type}}{Type of storage (cloud provider). Can be one of:
\code{s3}, \code{gcs}, \code{azure}, \code{OSS}.}

\item{\code{volume}}{Volume id.}

\item{\code{metadata}}{File metadata, if it exists.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-VolumeFile-new}{\code{VolumeFile$new()}}
\item \href{#method-VolumeFile-print}{\code{VolumeFile$print()}}
\item \href{#method-VolumeFile-reload}{\code{VolumeFile$reload()}}
\item \href{#method-VolumeFile-import}{\code{VolumeFile$import()}}
\item \href{#method-VolumeFile-clone}{\code{VolumeFile$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VolumeFile-new"></a>}}
\if{latex}{\out{\hypertarget{method-VolumeFile-new}{}}}
\subsection{Method \code{new()}}{
Create a new VolumeFile object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VolumeFile$new(res = NA, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{res}}{Response containing VolumeFile object info.}

\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VolumeFile-print"></a>}}
\if{latex}{\out{\hypertarget{method-VolumeFile-print}{}}}
\subsection{Method \code{print()}}{
Print method for VolumeFile class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VolumeFile$print()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume file is requested
volume_file_object <- VolumeFile$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print volume file object
 volume_file_object$print()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VolumeFile-reload"></a>}}
\if{latex}{\out{\hypertarget{method-VolumeFile-reload}{}}}
\subsection{Method \code{reload()}}{
Reload VolumeFile object information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VolumeFile$reload(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{VolumeFile}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume file is requested
volume_file_object <- VolumeFile$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload volume file object
 volume_file_object$reload()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VolumeFile-import"></a>}}
\if{latex}{\out{\hypertarget{method-VolumeFile-import}{}}}
\subsection{Method \code{import()}}{
This call lets you queue a job to import this file or
folder from a volume into a project on the Platform. \cr
Essentially, you are importing an item from your cloud storage provider
(Amazon Web Services, Google Cloud Storage, Azure or Ali Cloud) via the
volume onto the Platform. \cr
If successful, an alias will be created on the Platform. Aliases appear
on the Platform and can be copied, executed, and modified as such.
They refer back to the respective item on the given volume.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VolumeFile$import(
  destination_project = NULL,
  destination_parent = NULL,
  name = NULL,
  overwrite = FALSE,
  autorename = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{destination_project}}{String destination project id or Project
object. Not required, but either \code{destination_project} or
\code{destination_parent} directory must be provided.}

\item{\code{destination_parent}}{String folder id or File object
(with \code{type = 'FOLDER'}). Not required, but either \code{destination_project}
or \code{destination_parent} directory must be provided.}

\item{\code{name}}{The name of the alias to create. This name should be unique
to the project. \cr
If the name is already in use in the project, you should
use the \code{overwrite} query parameter in this call to force any item with
that name to be deleted before the alias is created.
If name is omitted, the alias name will default to the last segment of
the complete location (including the prefix) on the volume. \cr

Segments are considered to be separated with forward slashes /.
Allowed characters in file names are all alphanumeric and special
characters except forward slash /, while folder names can contain
alphanumeric and special characters _, - and ..}

\item{\code{overwrite}}{Set to \code{TRUE} if you want to overwrite the item if
another one with the same name already exists at the destination.
Bear in mind that if used with folders import, the folder's content
(files with the same name) will be overwritten, not the whole folder.}

\item{\code{autorename}}{Set to \code{TRUE} if you want to automatically rename the
item (by prefixing its name with an underscore and number) if another
one with the same name already exists at the destination.
Bear in mind that if used with folders import, the folder content will
be renamed, not the whole folder.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Import}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when volume file is requested
volume_file_object <- VolumeFile$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Import volume file object
 volume_file_object$import(destination_project = destination_project)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VolumeFile-clone"></a>}}
\if{latex}{\out{\hypertarget{method-VolumeFile-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VolumeFile$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
