% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_analytics.R
\name{sst_sa_domain_keywords_per_region}
\alias{sst_sa_domain_keywords_per_region}
\title{Number of keywords for each region for a domain}
\usage{
sst_sa_domain_keywords_per_region(
  domain,
  sort = "keywords_count",
  order = "desc",
  return_method = "list",
  api_token = Sys.getenv("SERPSTAT_API_TOKEN")
)
}
\arguments{
\item{domain}{(required) A domain name to analyze.}

\item{sort}{(optional) A field to sort the response. Allowed values: keywords_count, db_name, country_name_en, google_domain. Default: keywords_count.}

\item{order}{(optional) The order of sorting. Allowed values: asc, desc. Default: desc.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}

\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}. Default is Sys.getenv('SERPSTAT_API_TOKEN').}
}
\value{
Returns a data frame with number of keywords for each region for a domain.
}
\description{
Returns the number of keywords for each region for a domain. Regions with no keywords
are not returned.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://api-docs.serpstat.com/docs/serpstat-public-api/t84jvml38pg1q-get-regions-count}{here}.
}

\section{API credits consumption}{
 1 per returned region.
}

\examples{
\dontrun{
sst_sa_domain_keywords_per_region(
  domain        = 'serpstat.com',
  sort          = 'keywords_count',
  order         = 'desc',
  return_method = 'df'
)$data
}
}
