% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture_model.R
\name{estimate_from_mixture}
\alias{estimate_from_mixture}
\title{Estimate seroprevalence and foi by combining mixture model and regression}
\usage{
estimate_from_mixture(
  age,
  antibody_level,
  threshold_status = NULL,
  mixture_model,
  s = "ps",
  sp = 83,
  monotonize = TRUE
)
}
\arguments{
\item{age}{- vector of age}

\item{antibody_level}{- vector of the corresponding raw antibody level}

\item{threshold_status}{- sero status using threshold approach in line listing (optional, for visualization and comparison only)}

\item{mixture_model}{- mixture_model object generated by serosv::mixture_model()}

\item{s}{- smoothing basis used to fit antibody level}

\item{sp}{- smoothing parameter}

\item{monotonize}{- whether to monotonize seroprevalence (default to TRUE)}
}
\value{
a list of class estimated_from_mixture with the following items
  \item{df}{the dataframe used for fitting the model}
  \item{info}{a fitted "gam" model for mu(a)}
  \item{sp}{seroprevalence}
  \item{foi}{force of infection}
  \item{threshold_status}{serostatus using threshold method only if provided}
}
\description{
Refers to section 11.2 - 11.4
}
\seealso{
[mgcv::gam()] for more information about the fitted gam object
}
