% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-engine.R
\name{PRISMAReporter}
\alias{PRISMAReporter}
\title{PRISMA-Compliant Report Generator}
\description{
A comprehensive reporting system for generating PRISMA-compliant reports
from systematic review search analyses.
}
\details{
The PRISMAReporter class provides tools for:
\itemize{
\item Generating comprehensive search strategy reports
\item Creating PRISMA flow diagrams
\item Documenting search strategies
\item Exporting reports in multiple formats (HTML, PDF, Word)
}
}
\section{Methods}{

\describe{
\item{\code{new()}}{Initialize a new PRISMAReporter instance}
\item{\code{generate_report(search_analysis, output_format, template_type)}}{Generate comprehensive search strategy report}
\item{\code{generate_prisma_diagram(screening_data)}}{Generate PRISMA flow diagram}
\item{\code{document_search_strategy(search_strategy)}}{Generate search strategy documentation}
}
}

\examples{
# Create reporter
reporter <- PRISMAReporter$new()

# Create sample search strategy for documentation
search_strategy <- list(
  terms = c("systematic review", "meta-analysis", "evidence synthesis"),
  databases = c("PubMed", "Embase", "Cochrane"),
  date_range = as.Date(c("2020-01-01", "2023-12-31")),
  filters = list(language = "English", study_type = "RCT")
)

# Generate search strategy documentation
strategy_docs <- reporter$document_search_strategy(search_strategy)
print(strategy_docs)

# Create sample screening data for PRISMA diagram
screening_data <- data.frame(
  id = 1:100,
  duplicate = c(rep(FALSE, 80), rep(TRUE, 20)),
  title_abstract_screened = c(rep(TRUE, 80), rep(FALSE, 20)),
  full_text_eligible = c(rep(TRUE, 25), rep(FALSE, 75)),
  included = c(rep(TRUE, 15), rep(FALSE, 85)),
  excluded_title_abstract = c(rep(FALSE, 25), rep(TRUE, 55), rep(FALSE, 20)),
  excluded_full_text = c(rep(FALSE, 15), rep(TRUE, 10), rep(FALSE, 75))
)

# Generate PRISMA diagram
prisma_plot <- reporter$generate_prisma_diagram(screening_data)
print("PRISMA diagram created successfully")

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PRISMAReporter-new}{\code{PRISMAReporter$new()}}
\item \href{#method-PRISMAReporter-generate_report}{\code{PRISMAReporter$generate_report()}}
\item \href{#method-PRISMAReporter-generate_prisma_diagram}{\code{PRISMAReporter$generate_prisma_diagram()}}
\item \href{#method-PRISMAReporter-document_search_strategy}{\code{PRISMAReporter$document_search_strategy()}}
\item \href{#method-PRISMAReporter-clone}{\code{PRISMAReporter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PRISMAReporter-new"></a>}}
\if{latex}{\out{\hypertarget{method-PRISMAReporter-new}{}}}
\subsection{Method \code{new()}}{
Creates a new PRISMAReporter instance for generating PRISMA-compliant reports.
Sets up the necessary template paths and configuration.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PRISMAReporter$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value, called for side effects (initialization)
Generate comprehensive search strategy report
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PRISMAReporter-generate_report"></a>}}
\if{latex}{\out{\hypertarget{method-PRISMAReporter-generate_report}{}}}
\subsection{Method \code{generate_report()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PRISMAReporter$generate_report(
  search_analysis,
  output_format = "html",
  template_type = "comprehensive"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{search_analysis}}{SearchAnalyzer object}

\item{\code{output_format}}{Output format ("html", "pdf", "word")}

\item{\code{template_type}}{Type of report template}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Path to generated report
Generate PRISMA flow diagram
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PRISMAReporter-generate_prisma_diagram"></a>}}
\if{latex}{\out{\hypertarget{method-PRISMAReporter-generate_prisma_diagram}{}}}
\subsection{Method \code{generate_prisma_diagram()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PRISMAReporter$generate_prisma_diagram(screening_data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{screening_data}}{Data frame with screening results}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot object
Generate search strategy documentation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PRISMAReporter-document_search_strategy"></a>}}
\if{latex}{\out{\hypertarget{method-PRISMAReporter-document_search_strategy}{}}}
\subsection{Method \code{document_search_strategy()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PRISMAReporter$document_search_strategy(search_strategy)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{search_strategy}}{Search strategy object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Formatted documentation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PRISMAReporter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PRISMAReporter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PRISMAReporter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
