% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confnterval.R
\name{confnterval}
\alias{confnterval}
\title{confnterval}
\usage{
confnterval(est = NULL, ratio = NULL, ul = NULL, ll = NULL)
}
\arguments{
\item{est}{Enter the effect value.}

\item{ratio}{Effect ratio values. Includes OR,HR,RR.}

\item{ul}{The upper limit of the credible interval.}

\item{ll}{Lower limit of the credible interval.}
}
\value{
A list of results.
}
\description{
P-values were inferred from confidence intervals.
}
\details{
Limitations of the method:The formula for P is unreliable for very small P values and if your P value is smaller than 0.0001,
        just report it as P<0.0001.The methods described can be applied in a wide range of settings,
        including the results from meta-analysis and regression analyses.
        The main context where they are not correct is small samples where the outcome is continuous and the analysis has been done by a t test or analysis of variance,
        or the outcome is dichotomous and an exact method has been used for the confidence interval.
        However, even here the methods will be approximately correct in larger studies with, say,
        60 patients or more.
}
\examples{
confnterval(est=0.05917381,ul=0.06756194,ll=0.05091284)


}
\references{
Altman DG, Bland JM. How to obtain the P value from a confidence interval.
           BMJ. 2011;343:d2304. doi: 10.1136/bmj.d2304. PMID: 22803193.
}
