% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-spaces.R
\name{rgb_to_hsl}
\alias{rgb_to_hsl}
\title{Convert RGB space into HSL space}
\usage{
rgb_to_hsl(rgb)
}
\arguments{
\item{rgb}{A dataframe or matrix with red, green and blue colour channels located in the columns 1 to 3, respectively. Colour channel values should be between 0 and 255, inclusive.}
}
\value{
a \code{tibble} of H, S and L colour channels.
}
\description{
Convert RGB space into HSL space
}
\examples{
red <- sample(x = 1:255, size = 10, replace = TRUE)
green <- sample(x = 1:255, size = 10, replace = TRUE)
blue <- sample(x = 1:255, size = 10, replace = TRUE)
rgb_to_hsl(data.frame(r = red, g = green, b = blue))
}
