% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale.R
\name{rescale}
\alias{rescale}
\title{Rescales values of an scdf file}
\usage{
rescale(data, ..., m = 0, sd = 1)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{...}{Names of variables to be standardized.}

\item{m}{The target mean. If set NULL, it is not changed.}

\item{sd}{The target standard deviation. If set NULL, it is not changed.}
}
\value{
An scdf with the scaled values.
}
\description{
This function scales the measured values of an scdf file. It allows for mean
centering and standardization across all cases included in an scdf.
}
\examples{

## Standardize a multiple case scdf and compute an hplm
exampleAB_50 |>
  rescale(values, mt) |>
  hplm()
}
\seealso{
Other data manipulation functions: 
\code{\link{add_l2}()},
\code{\link{as.data.frame.scdf}()},
\code{\link{as_scdf}()},
\code{\link{fill_missing}()},
\code{\link{moving_median}()},
\code{\link{print.sc_outlier}()},
\code{\link{ranks}()},
\code{\link{scdf}()},
\code{\link{select_cases}()},
\code{\link{set_vars}()},
\code{\link{shift}()},
\code{\link{smooth_cases}()},
\code{\link{standardize}()},
\code{\link{truncate_phase}()}
}
\author{
Juergen Wilbert
}
\concept{data manipulation functions}
\keyword{internal}
