% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.export-bctau.R, R/corrected_tau.R
\name{print.sc_bctau}
\alias{print.sc_bctau}
\alias{export.sc_bctau}
\alias{corrected_tau}
\title{Baseline corrected tau}
\usage{
\method{print}{sc_bctau}(x, nice = TRUE, digits = "auto", ...)

\method{export}{sc_bctau}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  nice = TRUE,
  round = 2,
  ...
)

corrected_tau(
  data,
  dvar,
  pvar,
  mvar,
  phases = c(1, 2),
  alpha = 0.05,
  continuity = FALSE,
  repeated = FALSE,
  tau_method = c("b", "a")
)
}
\arguments{
\item{x}{An object returned by \code{\link[=corrected_tau]{corrected_tau()}}}

\item{nice}{If set TRUE (default) output values are rounded and optimized for
publication tables.}

\item{digits}{The minimum number of significant digits to be use.
If set to "auto" (default), values are predefined.}

\item{...}{Further parameters passed to the print function}

\item{object}{An scdf or an object exported from a scan function.}

\item{caption}{Character string with table caption. If left NA (default) a
caption will be created based on the exported object.}

\item{footnote}{Character string with table footnote. If left NA (default) a
footnote will be created based on the exported object.}

\item{filename}{String containing the file name. If a filename is given the
output will be written to that file.}

\item{round}{Integer passed to the digits argument used to round values.}

\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}

\item{phases}{A vector of two characters or numbers indicating the two phases
that should be compared. E.g., \code{phases = c("A","C")} or \code{phases = c(2,4)}
for comparing the second to the fourth phase. Phases could be combined by
providing a list with two elements. E.g., \code{phases = list(A = c(1,3), B = c(2,4))} will compare phases 1 and 3 (as A) against 2 and 4 (as B). Default
is \code{phases = c(1,2)}.}

\item{alpha}{Sets the p-value at and below which a baseline correction is
applied.}

\item{continuity}{If TRUE applies a continuity correction for calculating p}

\item{repeated}{If TRUE applies the repeated median method for calculating
slope and intercept.}

\item{tau_method}{Character with values "a" or "b" (default) indicating
whether Kendall Tau A or Kendall Tau B is applied.}
}
\description{
Kendall's tau correlation for the dependent variable and the phase variable
is calculated after correcting for a baseline trend.
}
\details{
This method has been proposed by Tarlow (2016). The baseline data
are checked for a significant autocorrelation (based on Kendall's Tau). If
so, a non-parametric Theil-Sen regression is applied for the baseline data
where the dependent values are regressed on the measurement time. The
resulting slope information is then used to predict data of the B-phase.
The dependent variable is now corrected for this baseline trend and the
residuals of the Theil-Sen regression are taken for further calculations.
Finally, Kendall's tau is calculated for the dependent variable and the
dichotomous phase variable. The function here provides two extensions to
this procedure: The more accurate Siegel repeated median regression is
applied when \code{repeated = TRUE} and a continuity correction is applied when
\code{continuity = TRUE}.
}
\section{Functions}{
\itemize{
\item \code{print(sc_bctau)}: Print results

\item \code{export(sc_bctau)}: Export results as html

}}
\examples{
dat <- scdf(c(A = 33,25,17,25,14,13,15, B = 15,16,16,5,7,9,6,5,3,3,8,11,7))
corrected_tau(dat)
}
\references{
Tarlow, K. R. (2016). An Improved Rank Correlation Effect Size
Statistic for Single-Case Designs: Baseline Corrected Tau. \emph{Behavior
Modification, 41(4)}, 427–467. https://doi.org/10.1177/0145445516676750
}
\seealso{
Other regression functions: 
\code{\link{bplm}()},
\code{\link{hplm}()},
\code{\link{mplm}()},
\code{\link{plm}()},
\code{\link{print.sc_ac}()},
\code{\link{trend}()}
}
\concept{regression functions}
