% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplezoo.R
\name{samplezoo}
\alias{samplezoo}
\title{Generate Samples with a Variety of Probability Distributions}
\usage{
samplezoo(name)
}
\arguments{
\item{name}{A character string specifying the dataset size.
The three dataset sizes are:
\itemize{
\item \code{small}: Generates a data frame with 100 samples per distribution.
\item \code{medium}: Generates a data frame with 1,000 samples per distribution.
\item \code{large}: Generates a data frame with 10,000 samples per distribution.
}}
}
\value{
A dataset containing variables with common distributions.
}
\description{
Generate Samples with a Variety of Probability Distributions
}
\details{
The distributions included in each data frame are:
\itemize{
\item \code{norm}: Normal distribution with mean and standard deviation parameters.
\item \code{norm_2}: Slight variation of the normal distribution.
\item \code{norm_3}: Another slight variation of the normal distribution.
\item \code{bern}: Bernoulli distribution.
\item \code{neg}: Negative binomial distribution.
\item \code{pois}: Poisson distribution.
\item \code{exp}: Exponential distribution.
\item \code{unif}: Uniform distribution.
\item \code{beta}: Beta distribution.
\item \code{gamma}: Gamma distribution.
\item \code{chi_sq}: Chi-squared distribution.
\item \code{t_dist}: Student's t-distribution.
\item \code{f_dist}: F-distribution.
}
}
\examples{
small_data <- samplezoo("small")
medium_data <- samplezoo("medium")
large_data <- samplezoo("large")
}
