% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaemixModel.R
\name{plot,SaemixModel,SaemixData-method}
\alias{plot,SaemixModel,SaemixData-method}
\alias{plot.SaemixModel}
\title{Plot model predictions for a new dataset. If the dataset is large, only the first 20 subjects (id's) will be shown.}
\usage{
\S4method{plot}{SaemixModel,SaemixData}(x, y, ...)
}
\arguments{
\item{x}{an SaemixModel object}

\item{y}{an SaemixData object}

\item{...}{additional arguments. Passing psi=X where X is a vector or a dataframe will allow
changing the parameters for which predictions are to be computed (defaults to the population parameters
defined by the psi element of x) (see details)}
}
\value{
a ggplot object
}
\description{
Plot model predictions for a new dataset. If the dataset is large, only the first 20 subjects (id's) will be shown.
}
\details{
The function uses the model slot of the SaemixModel object to obtain predictions, using the dataset contained in the
SaemixData object. The user is responsible for making sure data and model match.
If psi is not given, the predictions will be computed for the population parameters (first line of the psi0 slot) of the object.
If psi is given, the number of columns in psi (or the number of elements of psi, if psi is given as a vector) should match
the number of parameters in the model, otherwise an error message will be shown and the function will return empty.
If psi is a dataframe, each line will be used for a separate subject of the smx.data object. Elements of psi will be recycled
if psi has less lines than the number of subjects in the dataset.

Currently this function only works for models defined as 'structural'.
}
\examples{
data(theo.saemix)
saemix.data<-saemixData(name.data=theo.saemix,header=TRUE,sep=" ",na=NA,
   name.group=c("Id"),name.predictors=c("Dose","Time"),
   name.response=c("Concentration"),name.covariates=c("Weight","Sex"),
   units=list(x="hr",y="mg/L", covariates=c("kg","-")), name.X="Time")

model1cpt<-function(psi,id,xidep) { 
	  dose<-xidep[,1]
	  tim<-xidep[,2]  
	  ka<-psi[id,1]
	  V<-psi[id,2]
	  CL<-psi[id,3]
	  k<-CL/V
	  ypred<-dose*ka/(V*(ka-k))*(exp(-k*tim)-exp(-ka*tim))
	  return(ypred)
}

saemix.model<-saemixModel(model=model1cpt,modeltype="structural",
  description="One-compartment model with first-order absorption", 
  psi0=matrix(c(1.,20,0.5,0.1,0,-0.01),ncol=3, byrow=TRUE,
  dimnames=list(NULL, c("ka","V","CL"))),transform.par=c(1,1,1),
  covariate.model=matrix(c(0,1,0,0,0,0),ncol=3,byrow=TRUE),fixed.estim=c(1,1,1),
  covariance.model=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),
  omega.init=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),error.model="constant")

plot(saemix.model, saemix.data)
plot(saemix.model, saemix.data, psi=c(2, 40, 3))
indpsi<-data.frame(ka=2, V=seq(25,47,2), CL=seq(2.5,4.7, 0.2))
plot(saemix.model, saemix.data, psi=indpsi)

}
