% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{GM_2M_long_run_vol_no_skew}
\alias{GM_2M_long_run_vol_no_skew}
\title{GARCH-MIDAS-2M long-run volatility (without skewness)}
\usage{
GM_2M_long_run_vol_no_skew(
  param,
  daily_ret,
  mv_m_1,
  mv_m_2,
  K_1,
  K_2,
  lag_fun = "Beta"
)
}
\arguments{
\item{param}{Vector of starting values.}

\item{daily_ret}{Daily returns, which must be an "xts" object.}

\item{mv_m_1}{first MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{mv_m_2}{second MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{K_1}{Number of (lagged) realizations of the first MIDAS variable to consider.}

\item{K_2}{Number of (lagged) realizations of the second MIDAS variable to consider.}

\item{lag_fun}{\strong{optional}. Lag function to use. Valid choices are "Beta" (by default) and "Almon",
for the Beta and Exponential Almon lag functions, respectively.}
}
\value{
The resulting vector is the long-run volatility for each \eqn{i,t}.
}
\description{
Obtains the long-run volatility of the GARCH-MIDAS with two low-frequency variables.
For details, see \insertCite{engle_ghysels_sohn_2013;textual}{rumidas} and \insertCite{conrad_lock_2015;textual}{rumidas}.
}
\examples{
\donttest{
# conditional density of the innovations: normal
est_val<-c(alpha=0.01,beta=0.8,m=0,theta_1=0.1,w2_1=2,theta_2=0.1,w2_2=2)
r_t<-sp500['2005/2010']
mv_m_1<-mv_into_mat(r_t,diff(indpro),K=12,"monthly")
mv_m_2<-mv_into_mat(r_t,diff(indpro),K=24,"monthly")
head(GM_2M_long_run_vol_no_skew(est_val,r_t,mv_m_1,mv_m_2,K_1=12,K_2=24))
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mv_into_mat}}.
}
\keyword{internal}
