% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.R
\name{post_thread}
\alias{post_thread}
\title{Post a thread}
\usage{
post_thread(
  status = c("my first rtoot #rstats", "my first thread with rtoot"),
  token = NULL,
  sensitive = FALSE,
  spoiler_text = NULL,
  visibility = "public",
  scheduled_at = NULL,
  language = NULL,
  verbose = TRUE
)
}
\arguments{
\item{status}{character, toot status. Must be 500 characters or less.}

\item{token}{user bearer token (read from file by default)}

\item{sensitive}{logical, mark status and attached media as sensitive?}

\item{spoiler_text}{character, text to be shown as a warning or subject before the actual content. Statuses are generally collapsed behind this field.}

\item{visibility}{character, Visibility of the posted status. One of public (default), unlisted, private, direct.}

\item{scheduled_at}{ISO 8601 Datetime at which to schedule a status. Must be at least 5 minutes in the future.}

\item{language}{ISO 639 language code for this status.}

\item{verbose}{logical whether to display messages}
}
\value{
A character vector with the ids of the toots posted.
}
\description{
Create a thread of your messages.
}
\examples{
\dontrun{
pt <- post_thread(visibility = "direct")
}
}
