% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabs.R
\name{tabs}
\alias{tabs}
\title{Generate HTML Tabs with Dynamic Content}
\usage{
tabs(names, fun, groupname = .unique_name(), checked = 1, ...)
}
\arguments{
\item{names}{A character vector of tab labels.}

\item{fun}{A function that generates the content for each tab. It must take an index (`i`) as the first argument.}

\item{groupname}{A unique string to group the radio inputs (default is generated automatically).}

\item{checked}{The index of the tab that should be pre-selected (default is `1`).}

\item{...}{Additional arguments passed to `fun`.}
}
\value{
An `htmltools::tagList` containing the tabbed interface.
}
\description{
This function creates a tabbed interface where each tab has dynamically generated content.
}
\examples{
\dontrun{
tab_labels <- c("Tab1", "Tab2", "Tab3")

tab_content_fun <- function(i, extra_text = "") {
    htmltools::tagList(
        htmltools::tags$p(paste("Content for tab:", tab_labels[i], extra_text)),
        htmltools::tags$img(src = paste0("plot_", i, ".png"), width = "100\%")
    )
}

tabs(tab_labels, tab_content_fun, checked = 2, extra_text = "Additional details")
}
}
