% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo-prediction.R
\name{loo_predict.stanreg}
\alias{loo_predict.stanreg}
\alias{loo_predict}
\alias{loo_linpred}
\alias{loo_predictive_interval}
\alias{loo_linpred.stanreg}
\alias{loo_predictive_interval.stanreg}
\title{Compute weighted expectations using LOO}
\usage{
\method{loo_predict}{stanreg}(
  object,
  type = c("mean", "var", "quantile"),
  probs = 0.5,
  ...,
  psis_object = NULL
)

\method{loo_linpred}{stanreg}(
  object,
  type = c("mean", "var", "quantile"),
  probs = 0.5,
  transform = FALSE,
  ...,
  psis_object = NULL
)

\method{loo_predictive_interval}{stanreg}(object, prob = 0.9, ..., psis_object = NULL)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{type}{The type of expectation to compute. The options are
\code{"mean"}, \code{"variance"}, \code{"sd"}, and \code{"quantile"}.}

\item{probs}{For computing quantiles, a vector of probabilities.}

\item{...}{Currently unused.}

\item{psis_object}{An object returned by \code{\link[loo]{psis}}. If missing 
then \code{psis} will be run internally, which may be time consuming
for models fit to very large datasets.}

\item{transform}{Passed to \code{\link{posterior_linpred}}.}

\item{prob}{For \code{loo_predictive_interval}, a scalar in \eqn{(0,1)}
indicating the desired probability mass to include in the intervals. The
default is \code{prob=0.9} (\eqn{90}\% intervals).}
}
\value{
A list with elements \code{value} and \code{pareto_k}. 
  
  For \code{loo_predict} and \code{loo_linpred} the value component is a 
  vector with one element per observation. 
  
  For \code{loo_predictive_interval} the \code{value} component is a matrix
  with one row per observation and two columns (like
  \code{\link{predictive_interval}}). \code{loo_predictive_interval(..., prob
  = p)} is equivalent to \code{loo_predict(..., type = "quantile", probs =
  c(a, 1-a))} with \code{a = (1 - p)/2}, except it transposes the result and
  adds informative column names.
  
  See \code{\link[loo]{E_loo}} and \code{\link[loo]{pareto-k-diagnostic}} for
  details on the \code{pareto_k} diagnostic.
}
\description{
These functions are wrappers around the \code{\link[loo]{E_loo}} function
(\pkg{loo} package) that provide compatibility for \pkg{rstanarm} models.
}
\examples{
if (.Platform$OS.type != "windows" || .Platform$r_arch != "i386") {
\dontrun{
if (!exists("example_model")) example(example_model)

# optionally, log-weights can be pre-computed and reused
psis_result <- loo::psis(log_ratios = -log_lik(example_model))

loo_probs <- loo_linpred(example_model, type = "mean", transform = TRUE, psis_object = psis_result)
str(loo_probs)

loo_pred_var <- loo_predict(example_model, type = "var", psis_object = psis_result)
str(loo_pred_var)

loo_pred_ints <- loo_predictive_interval(example_model, prob = 0.8, psis_object = psis_result)
str(loo_pred_ints)
}
}
}
\references{
Vehtari, A., Gelman, A., and Gabry, J. (2017). Practical
  Bayesian model evaluation using leave-one-out cross-validation and WAIC.
  \emph{Statistics and Computing}. 27(5), 1413--1432.
  doi:10.1007/s11222-016-9696-4. arXiv preprint:
  \url{https://arxiv.org/abs/1507.04544}

  Yao, Y., Vehtari, A., Simpson, D., and Gelman, A. (2018) Using
  stacking to average Bayesian predictive distributions. \emph{Bayesian
  Analysis}, advance publication,  \doi{10.1214/17-BA1091}.

Gabry, J. , Simpson, D. , Vehtari, A. , Betancourt, M. and
  Gelman, A. (2019), Visualization in Bayesian workflow. \emph{J. R. Stat.
  Soc. A}, 182: 389-402. doi:10.1111/rssa.12378,
  \href{https://arxiv.org/abs/1709.01449}{arXiv preprint},
  \href{https://github.com/jgabry/bayes-vis-paper}{code on GitHub})
}
