% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slsd.R
\name{slsd}
\alias{slsd}
\title{Sample level signal denoising}
\usage{
slsd(
  kreports,
  method = "spearman",
  ...,
  min_reads = 3L,
  min_minimizer_n_unique = 3L,
  min_number = 3L
)
}
\arguments{
\item{kreports}{kreports data returned by \code{\link[=prep_dataset]{prep_dataset()}} for all samples.}

\item{method}{A character string indicating which correlation coefficient is
to be used for the test. One of "pearson", "kendall", or "spearman", can be
abbreviated.}

\item{...}{Other arguments passed to \link[stats:cor.test]{cor.test}.}

\item{min_reads}{An integer, the minimal number of the total reads to filter
taxa. SAHMI use \code{2}.}

\item{min_minimizer_n_unique}{An integer, the minimal number of the unique
number of minimizer to filter taxa. SAHMI use \code{2}.}

\item{min_number}{An integer, the minimal number of samples per taxid. SAHMI
use \code{4}.}
}
\value{
A polars \link[polars:DataFrame_class]{DataFrame} of correlation
coefficient and pvalue for \code{cor(minimizer_len, minimizer_n_unique)} (r1 and
p1), \code{cor(minimizer_len, total_reads)} (r2 and p2) and \code{cor(total_reads, minimizer_n_unique)} (r3 and p3).
}
\description{
In the low-microbiome biomass setting, real microbes also exhibit a
proportional number of total k-mers, number of unique k-mers, as well as
number of total assigned sequencing reads across samples; i.e. the following
three Spearman correlations are significant when tested using sample-level
data provided in Kraken reports: \code{cor(minimizer_len, minimizer_n_unique)},
\code{cor(minimizer_len, total_reads)} and \code{cor(total_reads, minimizer_n_unique)}.
(\code{r1>0 & r2>0 & r3>0 & p1<0.05 & p2<0.05 & p3<0.05}).
}
\examples{
\dontrun{
# `sahmi_datasets` should be the output of all samples from `prep_dataset()`
slsd <- slsd(lapply(sahmi_datasets, `[[`, "kreport"))
real_taxids_slsd <- slsd$filter(
    pl$col("r1")$gt(0),
    pl$col("r2")$gt(0),
    pl$col("r3")$gt(0),
    pl$col("p1")$lt(0.05),
    pl$col("p2")$lt(0.05),
    pl$col("p3")$lt(0.05)
)$get_column("taxid")
}
}
