% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Opal.R
\name{upload2opal}
\alias{upload2opal}
\title{Upload a resource on OPAL}
\usage{
upload2opal(
  test,
  display_name = NULL,
  access = 4,
  overwrite = TRUE,
  endpoint = NULL,
  open_in_browser = TRUE,
  as_survey = FALSE,
  api_user = NULL
)
}
\arguments{
\item{test}{A length one character vector of \link{AssessmentTest},
\link{AssessmentTestOpal} or \link{AssessmentItem} objects, Rmd/md or XML files;
required.}

\item{display_name}{A length one character vector to entitle file in OPAL;
file name without extension by default; optional.}

\item{access}{An integer value, optional; it is responsible for publication
status, where 1 - only those responsible for this learning resource; 2 -
responsible and other authors; 3 - all registered users; 4 - registered
users and guests. Default is 4.}

\item{overwrite}{A boolean value; if the value is \code{TRUE}, if only one file
with the specified display name is found, it will be overwritten. Default is
\code{TRUE}.}

\item{endpoint}{A string of endpoint of LMS Opal; by default it is got from
environment variable \code{RQTI_API_ENDPOINT}. To set a global environment
variable, you need to call \code{Sys.setenv(RQTI_API_ENDPOINT='xxxxxxxxxxxxxxx')}
or you can put these command into .Renviron.}

\item{open_in_browser}{A boolean value; optional; it controls whether to open
a URL in default browser. Default is \code{TRUE.}}

\item{as_survey}{A boolean value; optional; it controls resource type (test
r survey). Default is \code{FALSE}.}

\item{api_user}{A character value of the username in the OPAL.}
}
\value{
A list with the key, display name, and URL of the resource in Opal.
}
\description{
Function \code{upload2opal()} takes full prepared zip archive of QTI-test or
QTI-task and uploads it to the OPAL.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
file <- system.file("exercises/sc1.Rmd", package='rqti')
upload2opal(file, "task 1", open_in_browser = FALSE)
\dontshow{\}) # examplesIf}
}
