% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TextGapOpal.R
\name{textGapOpal}
\alias{textGapOpal}
\alias{gapTextOpal}
\title{Create object \link{TextGapOpal}}
\usage{
textGapOpal(
  solution,
  response_identifier = generate_id(type = "gap"),
  points = 1,
  placeholder = "",
  expected_length = size_gap(solution),
  case_sensitive = FALSE,
  tolerance = 0
)

gapTextOpal(
  solution,
  response_identifier = generate_id(type = "gap"),
  points = 1,
  placeholder = "",
  expected_length = size_gap(solution),
  case_sensitive = FALSE,
  tolerance = 0
)
}
\arguments{
\item{solution}{A character vector containing the values considered as correct
answers.}

\item{response_identifier}{A character value representing an identifier for
the answer. By default, it is generated as 'id_gap_dddd', where dddd
represents random digits.}

\item{points}{A numeric value, optional, representing the number of points for
this gap. Default is 1}

\item{placeholder}{A character value, optional, responsible for placing
helpful text in the text input field in the content delivery engine. Default
is "".}

\item{expected_length}{A numeric value, optional, responsible for setting the
size of the text input field in the content delivery engine. Default value
is adjusted by solution size.}

\item{case_sensitive}{A boolean value, determining whether the evaluation of
the correct answer is case sensitive. Default is \code{FALSE}.}

\item{tolerance}{A numeric value defining how many characters will be taken
into account to tolerate spelling mistakes in the evaluation of candidate
answers. Default is 0.}
}
\value{
An object of class \link{TextGapOpal}
}
\description{
Create object \link{TextGapOpal}
}
\examples{
tgo_min <- textGapOpal("answer")

tgo <- textGapOpal(solution = "answer",
             response_identifier  = "id_gap_1234",
             points = 2,
             placeholder = "put your answer here",
             expected_length = 20,
             case_sensitive = TRUE,
             tolerance = 2)
}
\seealso{
[entry()][numericGap()][textGap()]
}
