% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMS.R, R/Opal.R
\name{getCourseResult}
\alias{getCourseResult}
\alias{getCourseResult,missing-method}
\alias{getCourseResult,Opal-method}
\title{Get zip with course results by resource id and node id}
\usage{
getCourseResult(object, resource_id, node_id, path_outcome = ".", ...)

\S4method{getCourseResult}{missing}(object, resource_id, node_id, path_outcome = ".", ...)

\S4method{getCourseResult}{Opal}(
  object,
  resource_id,
  node_id,
  path_outcome = ".",
  rename = TRUE
)
}
\arguments{
\item{object}{An S4 object of class \link{Opal} that represents a connection to the LMS.}

\item{resource_id}{A length one character vector with resource id.}

\item{node_id}{A length one character vector with node id (test).}

\item{path_outcome}{A length one character vector with path, where the zip should be
stored. Default is working directory.}

\item{...}{Additional arguments to be passed to the method, if applicable.}

\item{rename}{A boolean value; optional; Set \code{TRUE} value to take the short
name of the course element for naming zip (results_shortName.zip). \code{FALSE}
combines in zip name course id and node id. Default is \code{TRUE}.}
}
\value{
It downloads a zip and return a character string with path.
}
\description{
This method retrieves zip with course results by its resource id and node id on Learning Management System (LMS).
If no LMS connection object is provided, it attempts to guess the connection using default settings (e.g., environment variables).
If the connection cannot be established, an error is thrown.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
zip_file <- getCourseResult("89068111333293", "1617337826161777006")
\dontshow{\}) # examplesIf}
}
