% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_transform.R
\name{replace_empty_values}
\alias{replace_empty_values}
\alias{replace_empty_values.flat_table}
\title{Replace empty values with the unknown value}
\usage{
replace_empty_values(ft, attributes, empty_values)

\method{replace_empty_values}{flat_table}(ft, attributes = NULL, empty_values = NULL)
}
\arguments{
\item{ft}{A \code{flat_table} object.}

\item{attributes}{A vector of names.}

\item{empty_values}{A vector of values that correspond to empty values.}
}
\value{
A \code{flat_table} object.
}
\description{
Transforms the given attributes by replacing the empty values with the unknown
value.
}
\details{
In addition to the NA or empty values, those indicated (e.g., "-") can be
considered as empty values.
}
\examples{

iris2 <- iris
iris2[10, 'Species'] <- NA
ft <- flat_table('iris', iris2) |>
  replace_empty_values()

}
\seealso{
\code{\link{flat_table}}

Other flat table transformation functions: 
\code{\link{add_custom_column}()},
\code{\link{remove_instances_without_measures}()},
\code{\link{replace_string}()},
\code{\link{replace_unknown_values}()},
\code{\link{select_attributes}()},
\code{\link{select_instances}()},
\code{\link{select_instances_by_comparison}()},
\code{\link{select_measures}()},
\code{\link{separate_measures}()},
\code{\link{transform_attribute_format}()},
\code{\link{transform_from_values}()},
\code{\link{transform_to_attribute}()},
\code{\link{transform_to_measure}()},
\code{\link{transform_to_values}()}
}
\concept{flat table transformation functions}
