% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rock.R
\docType{package}
\name{rock}
\alias{rock-package}
\alias{rock}
\title{rock: A Reproducible Open Coding Kit}
\description{
This package implements an open standard for working with
qualitative data, as such, it has two parts: a file format/convention
and this R package that facilitates working with .rock files.
}
\section{The ROCK File Format}{


The \code{.rock} files are plain text files where a number of conventions are used
to add metadata. Normally these are the following conventions:
\itemize{
\item The smallest 'codeable unit' is called an utterance, and utterances are separated by newline characters (i.e. every line of the file is an utterance);
\item Codes are in between double square brackets: \verb{[[code1]]} and \verb{[[code2]]};
\item Hierarchy in inductive code trees can be indicated using the greater than sign (\code{>}): \verb{[[parent1>child1]]};
\item Utterances can have unique identifiers called 'utterance identifiers' or 'UIDs', which are unique short alphanumeric strings placed in between double square brackets after 'uid:', e.g. \verb{[[uid:73xk2q07]]};
\item Deductive code trees can be specified using YAML
}
}

\section{The \code{rock} R Package Functions}{


The most important functions are \code{\link[=parse_source]{parse_source()}} to parse one source and \code{\link[=parse_sources]{parse_sources()}}
to parse multiple sources simultaneously. \code{\link[=clean_source]{clean_source()}} and \code{\link[=clean_sources]{clean_sources()}} can be used
to clean sources, and \code{\link[=prepend_ids_to_source]{prepend_ids_to_source()}} and \code{\link[=prepend_ids_to_sources]{prepend_ids_to_sources()}} can be
used to quickly generate UIDs and prepend them to each utterance in a source.

For analysis, \code{\link[=create_cooccurrence_matrix]{create_cooccurrence_matrix()}}, \code{\link[=collapse_occurrences]{collapse_occurrences()}}, and
\code{\link[=collect_coded_fragments]{collect_coded_fragments()}} can be used.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://rock.opens.science}
  \item Report bugs at \url{https://codeberg.org/R-packages/rock/issues}
}

}
\author{
\strong{Maintainer}: Gjalt-Jorn Peters \email{rock@opens.science} (\href{https://orcid.org/0000-0002-0336-9589}{ORCID}) [copyright holder]

Authors:
\itemize{
  \item Szilvia Zörgő (\href{https://orcid.org/0000-0002-6916-2097}{ORCID})
}

}
