% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_state_transition_table.R
\name{get_state_transition_table}
\alias{get_state_transition_table}
\title{Get the state transition table}
\usage{
get_state_transition_table(x, rawClassIdentifierCol = "state_raw")
}
\arguments{
\item{x}{A parsed source document as provided by \code{\link[=parse_source]{parse_source()}}.}

\item{rawClassIdentifierCol}{The identifier of the column in \code{x}'s QDT with
the raw class codings of the class that has the states to look at.}
}
\value{
A table, with the 'from' states as rows and the 'to' states as columns
}
\description{
Get the state transition table
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "state-example-1.rock");

### Parse single example source
parsedExample <- rock::parse_source(exampleFile);

### Show the state transition probabilities
rock::get_state_transition_table(
  parsedExample
);

}
