% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_ROCKproject.R
\name{export_ROCKproject}
\alias{export_ROCKproject}
\title{Export a ROCK project to a single ROCKproject file}
\usage{
export_ROCKproject(
  output,
  path = ".",
  config = NULL,
  includeRegex = NULL,
  excludeRegex = NULL,
  createDirs = FALSE,
  preventOverwriting = TRUE,
  forceBaseZip = FALSE,
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{output}{The file to write to; should have the extension \code{.ROCKproject}}

\item{path}{The path with the ROCK project}

\item{config}{Optionally, a named list with configuration options to
override. For supported options, see \code{vignette("ROCKproject-format", package = "rock");}}

\item{includeRegex}{A regular expression used to select files to include in
the project file}

\item{excludeRegex}{A regular expression used to omit files from the
project file; selection takes place after the selection by \code{includeRegex}}

\item{createDirs}{Whether to, if any directories in the \code{output} path does
not exist, create these}

\item{preventOverwriting}{If the output file already exists, whether to
prevent it from being overwritten (\code{TRUE}) or not (\code{FALSE}).}

\item{forceBaseZip}{Whether to force using the \code{zip()} function included in
R even if the \code{zip} package is installed.}

\item{silent}{Whether to be chatty or silent}
}
\value{
Invisibly, \code{output}.
}
\description{
Export a ROCK project to a single ROCKproject file
}
\examples{
### Get path to example project
examplePath <-
  system.file(
    "ROCKprojects",
    "exportable-ROCKproject-1",
    package="rock"
  );

### Get a temporary filename to write to
projectFilename <-
  tempfile(
    fileext = ".ROCKproject"
  );

### Export it
rock::export_ROCKproject(
  path = examplePath,
  output = projectFilename,
  silent = FALSE
);
}
