% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_occurrences.R
\name{count_occurrences}
\alias{count_occurrences}
\title{Count code occurrences}
\usage{
count_occurrences(x, codes = ".*", matchRegexAgainstPaths = TRUE)
}
\arguments{
\item{x}{A parsed source(s) object.}

\item{codes}{A regular expression to select codes to include, or,
alternatively, a character vector with literal code idenfitiers.}

\item{matchRegexAgainstPaths}{Whether to match the \code{codes} regular expression
against the full code paths or only against the code identifier.}
}
\value{
A \code{\link[=data.frame]{data.frame()}}.
}
\description{
Count code occurrences
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-3.rock");

### Load example source
loadedExample <- rock::parse_source(exampleFile);

### Show code occurrences
rock::count_occurrences(
  loadedExample
);
}
