% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_series.R
\name{replace_series}
\alias{replace_series}
\alias{verif_duplicates}
\alias{verif_ws_duplicates}
\title{Partial update of a workspace metadata}
\usage{
replace_series(
  ws_from,
  ws_to,
  selected_series,
  mp_from_name,
  mp_to_name,
  verbose = TRUE
)

verif_duplicates(s)

verif_ws_duplicates(ws, verbose = TRUE)
}
\arguments{
\item{ws_from}{The workspace containing the most up-to-date version of the
selected_series series}

\item{ws_to}{The workspace to update}

\item{selected_series}{The vector containing the series-to-update's names.}

\item{mp_from_name}{The name of the SA-Processing containing the series to
update (optional)}

\item{mp_to_name}{The name of the SA-Processing to update (optional)}

\item{verbose}{A boolean to print indications on the processing
status (optional and TRUE by default)}

\item{s}{a list of characters}

\item{ws}{The workspace to scan}
}
\value{
the updated \code{workspace}

If there are no duplicates, the function returns an empty data frame.
Otherwise, it returns a data frame giving the name and number of duplicates
found within the argument (list).

a list containing the name and number of occurences of duplicated SAPs and series
}
\description{
\code{replace_series()} allows to update a selection of series by the same-named
series from another workspace. When only the metadata differs, it is the
partial version of the update_metadata function.

Generic function to identify and return the duplicates in a list
}
\details{
If the arguments \code{mp_from_name} & \code{mp_to_name} are unspecified, the
update will be performed using the workspaces' first SAProcessing.
If a series is specified in the selected_series vector is missing in a
workspace, no replacement will be performed and the function will return the
list of missing series. Otherwise, if all is well, the function returns the
workspace ws_to updated.

\code{verif_duplicates()} identifies and returns the duplicates in a list
\code{verif_ws_duplicates()} identifies duplicated series in a SAProcessing (SAP)
and SAProcessings in a workspace
}
\examples{

library("RJDemetra")
dir_ws <- tempdir()
template_ws <- file.path(system.file("extdata", package = "rjdworkspace"),
                         "WS")
# Moving the WS in a temporary environment
copy_ws(
    ws_name = "ws_output",
    from = template_ws,
    to = dir_ws
)
copy_ws(
    ws_name = "ws_input",
    from = template_ws,
    to = dir_ws
)
path_ws_from <- file.path(dir_ws, "ws_input.xml")
path_ws_to <- file.path(dir_ws, "ws_output.xml")
ws_input <- load_workspace(path_ws_from)
ws_output <- load_workspace(path_ws_to)

replace_series(
    ws_from = ws_input,
    ws_to = ws_output,
    mp_from_name = "SAProcessing-2",
    mp_to_name = "SAProcessing-2",
    selected_series = c("RF1039", "RF1041"),
    verbose = TRUE
)


s <- c("a", "b", "a", "c", "a", "c")
print(rjdworkspace:::verif_duplicates(s))

}
