% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airm.R
\name{vec_at_id}
\alias{vec_at_id}
\title{Vectorize at Identity Matrix}
\usage{
vec_at_id(v)
}
\arguments{
\item{v}{A symmetric matrix of class \code{dspMatrix}.}
}
\value{
A numeric vector, representing the vectorized tangent image.
}
\description{
Converts a symmetric matrix into a vector representation specific to operations at the identity matrix.
}
\examples{
if (requireNamespace("Matrix", quietly = TRUE)) {
  library(Matrix)
  v <- diag(c(1, sqrt(2))) |>
    Matrix::symmpart() |>
    Matrix::pack()
  vec_at_id(v)
}
}
