% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parquet_backend.R
\name{ListBackend}
\alias{ListBackend}
\title{ListBackend Class}
\description{
Backend implementation using in-memory list storage.
This wraps the existing list-based storage mechanism for backwards compatibility.
}
\section{Super class}{
\code{\link[riemtan:DataBackend]{riemtan::DataBackend}} -> \code{ListBackend}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ListBackend-new}{\code{ListBackend$new()}}
\item \href{#method-ListBackend-get_matrix}{\code{ListBackend$get_matrix()}}
\item \href{#method-ListBackend-get_all_matrices}{\code{ListBackend$get_all_matrices()}}
\item \href{#method-ListBackend-length}{\code{ListBackend$length()}}
\item \href{#method-ListBackend-get_dimensions}{\code{ListBackend$get_dimensions()}}
\item \href{#method-ListBackend-clone}{\code{ListBackend$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ListBackend-new"></a>}}
\if{latex}{\out{\hypertarget{method-ListBackend-new}{}}}
\subsection{Method \code{new()}}{
Initialize a ListBackend
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListBackend$new(matrices)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{matrices}}{A list of dppMatrix objects}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ListBackend-get_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-ListBackend-get_matrix}{}}}
\subsection{Method \code{get_matrix()}}{
Get a specific matrix by index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListBackend$get_matrix(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{Integer index}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A dppMatrix object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ListBackend-get_all_matrices"></a>}}
\if{latex}{\out{\hypertarget{method-ListBackend-get_all_matrices}{}}}
\subsection{Method \code{get_all_matrices()}}{
Get all matrices
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListBackend$get_all_matrices()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of dppMatrix objects
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ListBackend-length"></a>}}
\if{latex}{\out{\hypertarget{method-ListBackend-length}{}}}
\subsection{Method \code{length()}}{
Get the number of matrices
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListBackend$length()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer count
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ListBackend-get_dimensions"></a>}}
\if{latex}{\out{\hypertarget{method-ListBackend-get_dimensions}{}}}
\subsection{Method \code{get_dimensions()}}{
Get matrix dimensions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListBackend$get_dimensions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer p (matrices are p x p)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ListBackend-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ListBackend-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListBackend$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
