% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parquet_backend.R
\name{DataBackend}
\alias{DataBackend}
\title{DataBackend Abstract Class}
\description{
Abstract base class defining the interface for storage backends.
All backend implementations must inherit from this class and implement
the required methods.
}
\details{
This class provides a common interface for different storage strategies:
\itemize{
\item ListBackend: In-memory list storage (current default)
\item ParquetBackend: Lazy-loaded Parquet files with LRU cache
}
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataBackend-get_matrix}{\code{DataBackend$get_matrix()}}
\item \href{#method-DataBackend-get_all_matrices}{\code{DataBackend$get_all_matrices()}}
\item \href{#method-DataBackend-length}{\code{DataBackend$length()}}
\item \href{#method-DataBackend-get_dimensions}{\code{DataBackend$get_dimensions()}}
\item \href{#method-DataBackend-clone}{\code{DataBackend$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackend-get_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackend-get_matrix}{}}}
\subsection{Method \code{get_matrix()}}{
Get a specific matrix by index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackend$get_matrix(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{Integer index of the matrix to retrieve}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A dppMatrix object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackend-get_all_matrices"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackend-get_all_matrices}{}}}
\subsection{Method \code{get_all_matrices()}}{
Get all matrices
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackend$get_all_matrices()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of dppMatrix objects
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackend-length"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackend-length}{}}}
\subsection{Method \code{length()}}{
Get the number of matrices
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackend$length()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer count of matrices
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackend-get_dimensions"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackend-get_dimensions}{}}}
\subsection{Method \code{get_dimensions()}}{
Get matrix dimensions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackend$get_dimensions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer dimension (p) where matrices are p x p
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataBackend-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataBackend-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataBackend$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
