ticktype <- function(t)
{
  res <- map_ticktype[t]

  if(is.na(res)) {
    warning("unknown ticktype: ", t)
    "UNKNOWN"
  }
  else
    res
}

map_ticktype <- c( "0" = "BID_SIZE",
                   "1" = "BID",
                   "2" = "ASK",
                   "3" = "ASK_SIZE",
                   "4" = "LAST",
                   "5" = "LAST_SIZE",
                   "6" = "HIGH",
                   "7" = "LOW",
                   "8" = "VOLUME",
                   "9" = "CLOSE",
                  "10" = "BID_OPTION",
                  "11" = "ASK_OPTION",
                  "12" = "LAST_OPTION",
                  "13" = "MODEL_OPTION",
                  "14" = "OPEN",
                  "15" = "LOW_13_WEEK",
                  "16" = "HIGH_13_WEEK",
                  "17" = "LOW_26_WEEK",
                  "18" = "HIGH_26_WEEK",
                  "19" = "LOW_52_WEEK",
                  "20" = "HIGH_52_WEEK",
                  "21" = "AVG_VOLUME",
                  "22" = "OPEN_INTEREST",
                  "23" = "OPTION_HISTORICAL_VOL",
                  "24" = "OPTION_IMPLIED_VOL",
                  "25" = "OPTION_BID_EXCH",
                  "26" = "OPTION_ASK_EXCH",
                  "27" = "OPTION_CALL_OPEN_INTEREST",
                  "28" = "OPTION_PUT_OPEN_INTEREST",
                  "29" = "OPTION_CALL_VOLUME",
                  "30" = "OPTION_PUT_VOLUME",
                  "31" = "INDEX_FUTURE_PREMIUM",
                  "32" = "BID_EXCH",
                  "33" = "ASK_EXCH",
                  "34" = "AUCTION_VOLUME",
                  "35" = "AUCTION_PRICE",
                  "36" = "AUCTION_IMBALANCE",
                  "37" = "MARK_PRICE",
                  "38" = "BID_EFP_COMPUTATION",
                  "39" = "ASK_EFP_COMPUTATION",
                  "40" = "LAST_EFP_COMPUTATION",
                  "41" = "OPEN_EFP_COMPUTATION",
                  "42" = "HIGH_EFP_COMPUTATION",
                  "43" = "LOW_EFP_COMPUTATION",
                  "44" = "CLOSE_EFP_COMPUTATION",
                  "45" = "LAST_TIMESTAMP",
                  "46" = "SHORTABLE",
                  "47" = "FUNDAMENTAL_RATIOS",
                  "48" = "RT_VOLUME",
                  "49" = "HALTED",
                  "50" = "BID_YIELD",
                  "51" = "ASK_YIELD",
                  "52" = "LAST_YIELD",
                  "53" = "CUST_OPTION_COMPUTATION",
                  "54" = "TRADE_COUNT",
                  "55" = "TRADE_RATE",
                  "56" = "VOLUME_RATE",
                  "57" = "LAST_RTH_TRADE",
                  "58" = "RT_HISTORICAL_VOL",
                  "59" = "IB_DIVIDENDS",
                  "60" = "BOND_FACTOR_MULTIPLIER",
                  "61" = "REGULATORY_IMBALANCE",
                  "62" = "NEWS_TICK",
                  "63" = "SHORT_TERM_VOLUME_3_MIN",
                  "64" = "SHORT_TERM_VOLUME_5_MIN",
                  "65" = "SHORT_TERM_VOLUME_10_MIN",
                  "66" = "DELAYED_BID",
                  "67" = "DELAYED_ASK",
                  "68" = "DELAYED_LAST",
                  "69" = "DELAYED_BID_SIZE",
                  "70" = "DELAYED_ASK_SIZE",
                  "71" = "DELAYED_LAST_SIZE",
                  "72" = "DELAYED_HIGH",
                  "73" = "DELAYED_LOW",
                  "74" = "DELAYED_VOLUME",
                  "75" = "DELAYED_CLOSE",
                  "76" = "DELAYED_OPEN",
                  "77" = "RT_TRD_VOLUME",
                  "78" = "CREDITMAN_MARK_PRICE",
                  "79" = "CREDITMAN_SLOW_MARK_PRICE",
                  "80" = "DELAYED_BID_OPTION",
                  "81" = "DELAYED_ASK_OPTION",
                  "82" = "DELAYED_LAST_OPTION",
                  "83" = "DELAYED_MODEL_OPTION",
                  "84" = "LAST_EXCH",
                  "85" = "LAST_REG_TIME",
                  "86" = "FUTURES_OPEN_INTEREST",
                  "87" = "AVG_OPT_VOLUME",
                  "88" = "DELAYED_LAST_TIMESTAMP",
                  "89" = "SHORTABLE_SHARES",
                  "90" = "DELAYED_HALTED",
                  "91" = "REUTERS_2_MUTUAL_FUNDS",
                  "92" = "ETF_NAV_CLOSE",
                  "93" = "ETF_NAV_PRIOR_CLOSE",
                  "94" = "ETF_NAV_BID",
                  "95" = "ETF_NAV_ASK",
                  "96" = "ETF_NAV_LAST",
                  "97" = "ETF_FROZEN_NAV_LAST",
                  "98" = "ETF_NAV_HIGH",
                  "99" = "ETF_NAV_LOW",
                 "100" = "SOCIAL_MARKET_ANALYTICS",
                 "101" = "ESTIMATED_IPO_MIDPOINT",
                 "102" = "FINAL_IPO_LAST",
                 "103" = "DELAYED_YIELD_BID",
                 "104" = "DELAYED_YIELD_ASK")


funddist <- function(v) switch(v,
                               N= "Accumulation Fund",
                               Y= "Income Fund",
                                  "None")


fundtype <- function(v) switch(v,
                               "000" = "Others",
                               "001" = "Money Market",
                               "002" = "Fixed Income",
                               "003" = "Multi-asset",
                               "004" = "Equity",
                               "005" = "Sector",
                               "006" = "Guaranteed",
                               "007" = "Alternative",
                                       "None")
