% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleg6.R
\docType{data}
\name{sampleg6}
\alias{sampleg6}
\alias{g6}
\alias{d6}
\alias{s6}
\title{Example vectors of 'graph6', 'sparse6', and 'digraph6' codes}
\format{
The three objects \code{g6}, \code{s6}, and \code{d6} are character vectors of
length 20 corresponding to undirected (in case of \code{g6} and \code{s6}) and
directed (in case of \code{d6}) graphs of varying sizes and densities.

Object \code{sampleg6} is a character vector of length 9 of
undirected graphs in 'graph6' format.
}
\usage{
g6

s6

d6

sampleg6
}
\description{
Objects \code{g6}, \code{s6}, and \code{d6} are vectors of codes in 'graph6', 'sparse6', and
'digraph6' representations respectively. Object \code{sampleg6} is a vector of
'graph6' codes.
}
\details{
Graphs in \code{g6}, \code{s6}, and \code{d6} objects were generated using the
common algorithm which consists of the following steps:
\enumerate{
\item For each value from the vector of sizes of the node set (15, 30, 60, 120)...
\item ... generate a vector of edge counts (size of the edge set) of length 5
ranging from a single edge up to an edge count corresponding to the density
of 0.2.
\item Given the node set sizes (item 1) and edge set sizes (item 2) sample
undirected graphs from GNM model.
\item These undirected graphs are encoded in \code{g6} and \code{s6}
\item Directed graphs were created by turning undirected edges to directed
arcs in an arbitrary manner. These are encoded in the \code{d6} object.
}
}
\keyword{datasets}
