% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgeomorphon-package.R
\docType{data}
\name{salton}
\alias{salton}
\title{Bathymetric Information on California's Salton Sea}
\format{
matrix, with cells representing X, Y grid locations, and attributes
\code{"crs"} (containing WKT2019 string with coordinate reference system
information) and \code{"extent"} (named numeric of length 4, containing xmin,
xmax, ymin, ymax)
}
\source{
California Division of Fish and Wildlife. 2007. Bathymetric Contours
(1 foot) - Salton Sea (ds426). Available online:
\url{https://map.dfg.ca.gov/metadata/ds0426.html}
}
\usage{
salton
}
\description{
Matrix derived from one foot contours of the Salton Sea floor. This data was
created with the vertical datum NGVD29 and NAD83 California Teale Albers
(EPSG:3110) projection. Each value in the matrix represents the elevation, in
meters, of a 300 m x 300 m cell. Cell values are interpolated using a thin
plate spline fit to an exhaustive sample of contour line vertices.
}
\examples{
\dontshow{if (requireNamespace("terra")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

str(salton)

# construct and georeference a SpatRaster object
dem <- terra::rast(salton)
terra::crs(dem) <- attr(salton, "crs")
terra::ext(dem) <- attr(salton, "extent")
names(dem) <- "Elevation (feet)"

dem
\dontshow{\}) # examplesIf}
}
\keyword{datasets}
