% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_jobs.R
\name{gen_download_job}
\alias{gen_download_job}
\title{gen_download_job}
\usage{
gen_download_job(
  name,
  database = c("genesis", "regio"),
  area = c("all", "public", "user"),
  compress = FALSE,
  language = Sys.getenv("RESTATIS_LANG"),
  all_character = TRUE
)
}
\arguments{
\item{name}{Character string. The job code retrieved by using gen_list_jobs().}

\item{database}{Character string. Indicator if the GENESIS ('genesis') or regionalstatistik.de ('regio') database is called. Only one database can be addressed per function call. Default option is 'genesis'.}

\item{area}{Character string. Indicator from which area of the database the results are called. In general, 'all' is the appropriate solution. Default option is 'all'.}

\item{compress}{Boolean. Should empty rows and columns be discarded? Default is FALSE.}

\item{language}{Character string. Defines if the decimal mark and grouping mark of integers should be represented based on the European (e.g.: '100,5', '200.000,5') or American ('100.5', '200,000.5') system. Defaults to 'Sys.getenv("RESTATIS_LANG")'.}

\item{all_character}{Boolean. Should all variables be imported as 'character' variables? Avoids fuzzy data type conversions if there are leading zeros or other special characters. Defaults to TRUE.}
}
\value{
Returns a data.frame with the table content
}
\description{
gen_download_job
}
\examples{
\dontrun{
gen_download_job("21311-00-01-1_123456789", "regio")
}

}
