% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_performance.R
\name{report_performance}
\alias{report_performance}
\title{Report the model's quality and fit indices}
\usage{
report_performance(x, table = NULL, ...)
}
\arguments{
\item{x}{The R object that you want to report (see list of of supported
objects above).}

\item{table}{A table obtained via \code{report_table()}. If not provided,
will run it.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
An object of class \code{\link[=report_performance]{report_performance()}}.
}
\description{
Investigating the fit of statistical models to data often involves selecting
the best fitting model amongst many competing models. This function helps
report indices of model fit for various models.  Reports the type of
different R objects . For a list of supported objects, see
\code{\link[=report]{report()}}).
}
\examples{
\donttest{
# GLMs
report_performance(lm(Sepal.Length ~ Petal.Length * Species, data = iris))
report_performance(glm(vs ~ disp, data = mtcars, family = "binomial"))
}

\dontshow{if (requireNamespace("lme4", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
# Mixed models
library(lme4)
model <- lme4::lmer(Sepal.Length ~ Petal.Length + (1 | Species), data = iris)
report_performance(model)
}
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("rstanarm", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
# Bayesian models
library(rstanarm)
model <- suppressWarnings(stan_glm(Sepal.Length ~ Species, data = iris, refresh = 0, iter = 600))
report_performance(model)
}
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("lavaan", quietly = TRUE) && packageVersion("effectsize") >= "0.6.0.1") withAutoprint(\{ # examplesIf}
\donttest{
# Structural Equation Models (SEM)
library(lavaan)
structure <- "ind60 =~ x1 + x2 + x3
              dem60 =~ y1 + y2 + y3
              dem60 ~ ind60 "
model <- lavaan::sem(structure, data = PoliticalDemocracy)
suppressWarnings(report_performance(model))
}
\dontshow{\}) # examplesIf}
}
