% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.remstats}
\alias{print.remstats}
\title{Printing Relational Event Network Statistics}
\usage{
\method{print}{remstats}(x, ...)
}
\arguments{
\item{x}{object of class \code{\link{remstats}}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The function prints formatted information about the remstats object to the console, presenting details about the relational event network statistics in a user-friendly format.
}
\description{
Print a \code{\link{remstats}} object in a user-friendly format.
}
\examples{
rehObject <- remify::remify(edgelist = history, model = "tie")
remstatsObject <- remstats::remstats(reh = rehObject, tie_effects = ~ remstats::inertia())
print(remstatsObject)

rehObject <- remify::remify(edgelist = history, model = "actor")
remstatsObject <- remstats::remstats(reh = rehObject, receiver_effects = ~ inertia())
print(remstatsObject)

}
