% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDatamatrix.R
\name{createDatamatrix}
\alias{createDatamatrix}
\title{Create data matrix with possible genotype combinations for specified individuals}
\usage{
createDatamatrix(locus, knownGenos, idsU = NULL)
}
\arguments{
\item{locus}{A list of class \code{\link[Familias]{FamiliasLocus}} containing information about the locus}

\item{knownGenos}{List of known genotypes. Each element is a vector with genotype for one individual. The elements must be named}

\item{idsU}{Vector of indices for unknown individuals}
}
\value{
A data matrix of genotypes where each row corresponds to an individual.
}
\description{
A data matrix of genotypes for known individuals and all possible genotypes for unknown individuals is created.
}
\examples{
#Define alleles and frequencies
alleles <- 1:2
afreq <- c(0.5,0.5)
#Create locus object
locus <- Familias::FamiliasLocus(frequencies=afreq,name="M1",allelenames= alleles)
#Known genotypes of alleged father and mother, child's genotype is uknown
gAF <- c(1,1)
gMO <- c(1,1)
datamatrix <- createDatamatrix(locus,knownGenos=list(AF=gAF,MO=gMO),idsU=c("CH"))
}
\seealso{
\code{\link[Familias]{FamiliasLocus}}.
}
\author{
Guro Dorum
}
