% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.pfr.R
\name{plot.pfr}
\alias{plot.pfr}
\title{Plot a pfr object}
\usage{
\method{plot}{pfr}(x, Qtransform = FALSE, ...)
}
\arguments{
\item{x}{a fitted \code{pfr}-object}

\item{Qtransform}{For additive functional terms, \code{TRUE} indicates the
coefficient should be plotted on the quantile-transformed scale, whereas
\code{FALSE} indicates the scale of the original data. Note this is
different from the \code{Qtransform} arguemnt of \code{af}, which specifies
the scale on which the term is fit.}

\item{...}{arguments handed over to \code{\link[mgcv]{plot.gam}}}
}
\value{
This function's main purpose is its side effect of generating plots.
It also silently returns a list of the data used to produce the plots, which
can be used to generate customized plots.
}
\description{
This function plots the smooth coefficients of a pfr object. These include
functional coefficients as well as any smooths of scalar covariates. The
function dispatches to \code{pfr_plot.gam}, which is our local copy of
\code{\link[mgcv]{plot.gam}} with some minor changes.
}
\seealso{
\code{\link{af}}, \code{\link{pfr}}
}
\author{
Jonathan Gellar
}
