% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_research.R
\name{rl_research}
\alias{rl_research}
\title{IUCN Red List research categories}
\usage{
rl_research(
  code = NULL,
  year_published = NULL,
  latest = NULL,
  possibly_extinct = NULL,
  possibly_extinct_in_the_wild = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{code}{Character Or Numeric. One or more research category codes (e.g., "1", "2").
Use \code{\link[=rl_research]{rl_research()}} to list available research categories.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{possibly_extinct}{Optional. Logical. Filter for species flagged as possibly extinct.}

\item{possibly_extinct_in_the_wild}{Optional. Logical. Filter for species possibly extinct in the wild.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
If \code{code = NULL}, the tibble contains available research categories with columns such as code and description.
If \code{code} is provided, the tibble contains assessment data for the specified research need(s), including description,
research code, year, taxon details, and other relevant metadata.
}
\description{
Retrieve species assessments based on their research needs categories.
If \code{code = NULL}, it returns a list of available research categories.
If \code{code} is provided, it retrieves assessments for species with the specified research need(s).
}
\examples{
\dontrun{
# List all research categories
rl_research()

# Get species needing population trends research (code 3_1)
rl_research(code = "3_1")

# Get species needing life history & ecology research published since 2019
rl_research(
  code = "1_3",
  year_published = 2019:2023
)
}
}
