#' La care clase și zile intră profesorul, singur sau în cuplaje
#'
#' Între altele, vom putea sesiza situația defectuoasă în care un profesor a
#' căpătat în total (cumulând orele proprii cu cele din cuplaje) 6 sau 7 ore 
#' pe o zi, dar niciuna dintre clasele implicate nu ajunge în ziua respectivă,
#' la a 6-a respectiv, a 7-a oră.

#' @param DZ Repartiția curentă pe zile
#' @param P Profesorul, sau un vector de profesori
#' @return Tabel conținând pe zile, clasele repartizate profesorului
#' @export
#'
#' @examples
#' # clasele repartizate pe zile lui 'Fz1', respectiv la doi profesori 'Gr*'
#' Fz <- cls2prof(R123, "Fz1")
#' Gr <- cls2prof(R123, paste0("Gr", 1:2))
#'
cls2prof <- function(DZ, P) {
    SL <- DZ %>% filter(.data$prof %in% P)
    split(SL, SL$zl) %>%
        map(function(Oz) paste(Oz$cls, collapse=" ")) %>%
        list2DF() %>% t() %>% 
        `colnames<-`(paste(P, collapse=", ")) %>% `rownames<-`(Zile)
}

