#' Pe repartiția pe zile curentă, schimbă într-o altă zi, lecția indicată
#'
#' După ce se investighează (prin 'prof_2days()', 'prof_swap()', etc.)
#' distribuția lecțiilor unui profesor în cadrul repartiției curente,
#' se poate decide schimbarea zilei alocate lui la o anumită clasă.
#'
#' @param DZ Distribuția curentă a lecțiilor, pe zile.
#' @param P,Q,Z Profesorul, clasa și ziua (din 'Zile') curent alocată.
#' @param new_zl Ziua (din 'Zile') cu care trebuie înlocuită cea existentă.
#' @return Distribuția rezultată după realocarea lecției.
#' @export

change_day <- function(DZ, P, Q, Z, new_zl) {
    wh <- which(with(DZ, prof==P & cls==Q & zl==Z) == TRUE)
    if(length(wh) > 1) wh <- wh[1] # mută numai una dintre orele existente
    DZ[wh, "zl"] <- new_zl
    DZ
}

