% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_range.R
\name{number_range}
\alias{number_range}
\title{Generate a regular expression for a number range.}
\usage{
number_range(lo, hi, allow_leading_zeroes = FALSE, capture = FALSE)
}
\arguments{
\item{lo}{An integer.}

\item{hi}{An integer greater than or equal to \code{lo}.}

\item{allow_leading_zeroes}{A logical value. Are leading zeroes allowed to
bulk the match up to the length of the number with the most digits?}

\item{capture}{A logical value. See \code{\link[rebus.base]{or}} for details.}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Generates a regular expression that matches a sequence of numbers.
}
\examples{
number_range(0, 255)
number_range(0, 255, allow_leading_zeroes = TRUE)
number_range(10000, 19999)
number_range(6, 54321)
number_range(-77, 77)
number_range(-77, 77, capture = TRUE)
number_range(-77, 77, capture = NA)
}
