% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_catalogues.R
\name{search_catalogues}
\alias{search_catalogues}
\title{Search for ABS catalogues that match a string}
\usage{
search_catalogues(string, refresh = FALSE)
}
\arguments{
\item{string}{Character. A word or phrase you want to search for, such as "labour" or
"union". Not case sensitive.}

\item{refresh}{Logical. \code{FALSE} by default. If \code{TRUE}, will re-scrape the ABS
website to ensure that the list of catalogues is up-to-date.}
}
\value{
A data frame (tibble) containing the topic (\code{heading}), product title
(\code{sub_heading}), catalogue (\code{catalogue}) and URL (\code{URL}) of any catalogues
that match the provided string.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Helper function to use with \code{download_abs_data_cube()}.

\code{download_abs_data_cube()} requires that you specify a \code{catalogue}.
\code{search_catalogues()} helps you find the catalogue you want, by searching for
a given string in the catalogue names, product title, and broad topic.
}
\examples{

search_catalogues("labour")
}
\seealso{
Other data cube functions: 
\code{\link{download_abs_data_cube}()},
\code{\link{show_available_catalogues}()},
\code{\link{show_available_files}()}
}
\concept{data cube functions}
