% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_job_mobility.R
\name{read_job_mobility}
\alias{read_job_mobility}
\title{Download and tidy ABS Job Mobility tables}
\usage{
read_job_mobility(
  tables = "all",
  path = Sys.getenv("R_READABS_PATH", unset = tempdir())
)
}
\arguments{
\item{tables}{Either \code{"all"} (the default) to import all tables, or a
vector of table numbers, such as \code{1} or \code{c(2, 4)}.}

\item{path}{Local directory in which downloaded ABS time series spreadsheets should be stored. By default, 'path' takes the value set in the environment variable "R_READABS_PATH". If this variable is not set, any files downloaded by read_abs() will be stored in a temporary directory (tempdir()).}
}
\description{
Import a tidy tibble of ABS Job Mobility data
}
\examples{
\dontrun{
# Get all tables from the ABS Job Mobility series
read_job_mobility()

# Get tables 1 and 2
read_job_mobility(c(1, 2))
}

}
