% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{query}
\alias{query}
\title{Query Documents in a Collection}
\usage{
query(
  client,
  collection_name,
  query_embeddings,
  n_results = 10L,
  where = NULL,
  where_document = NULL,
  include = c("documents", "metadatas", "distances"),
  tenant = "default_tenant",
  database = "default_database"
)
}
\arguments{
\item{client}{A ChromaDB client object}

\item{collection_name}{Name of the collection}

\item{query_embeddings}{List of query embeddings (must be a list of numeric vectors)}

\item{n_results}{Number of results to return per query (default: 10)}

\item{where}{Optional filtering conditions}

\item{where_document}{Optional document-based filtering conditions}

\item{include}{Optional vector of what to include in results. Possible values:
"documents", "embeddings", "metadatas", "distances", "uris", "data"
(default: c("documents", "metadatas", "distances"))}

\item{tenant}{The tenant name (default: "default")}

\item{database}{The database name (default: "default")}
}
\value{
A list containing the query results. Each element (documents, metadatas, distances)
is a nested list, so use double brackets [[]] to access individual elements.
}
\description{
Query Documents in a Collection
}
\details{
Note that ChromaDB's API only accepts embeddings for queries. If you want to query using
text, you need to first convert your text to embeddings using an embedding model
(e.g., using OpenAI's API, HuggingFace's API, or a local model).

Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# First convert text to embeddings using your preferred method
text_embedding <- your_embedding_function("your search text")
# Then query using the embedding
result <- query(client, "my_collection",
               query_embeddings = list(text_embedding))
}\if{html}{\out{</div>}}
}
