% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_qtree.R
\name{polar_qtree}
\alias{polar_qtree}
\title{Generate polar quadtree segmentation}
\usage{
polar_qtree(r, z, a, scale_parameter, angle_width = 30, max_splittings = 6)
}
\arguments{
\item{r}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster}. One or more layers used to drive
heterogeneity.}

\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{scale_parameter}{numeric vector of length one. Threshold on \code{delta}
controlling splits (see \emph{Details}).}

\item{angle_width}{numeric vector of length one. Angle in deg that must
divide both 0–360 and 0–90 into an integer number of segments. Retrieve a
set of valid values by running
\code{lapply(c(45, 30, 18, 10), function(a) vapply(0:6, function(x) a/2^x, 1))}.}

\item{max_splittings}{numeric vector of length one. Maximum recursion depth.}
}
\value{
Single-layer \link[terra:SpatRaster-class]{terra::SpatRaster} with integer values and the
same number of rows and columns as \code{r}.
}
\description{
Segment a hemispherical image into large circular trapezoids and
recursively split them into four trapezoids of equal angular size whenever
brightness heterogeneity exceeds a predefined threshold.
}
\details{
A circular trapezoid, hereafter referred to as a cell, is the
intersection of a ring (zenith‑angle band) and a sector (azimuth‑angle band).
Heterogeneity within a cell is measured as the standard deviation of pixel
values (a first‑order texture metric). The change in heterogeneity due to
splitting is \code{delta}, defined as the sum of the standard deviations of the
four subcells minus the standard deviation of the parent cell. A split is
kept where \code{delta > scale_parameter}. For multi‑layer \code{r}, \code{delta} is
computed per layer and averaged to decide splits. Angular resolution at level
\code{i} is \code{angle_width / 2^i}.
}
\examples{
\dontrun{
# Find large patches of white ---------------------------------------------
caim <- read_caim()
r <- caim$Blue
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)

bin <- binarize_with_thr(r, thr_isodata(r[]))
plot(bin)

seg <- polar_qtree(bin, z, a, 0, 30, 3)
plot(extract_feature(bin, seg) == 1)
}
}
