% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data3d.R
\name{Data3D}
\alias{Data3D}
\alias{get_data3d_value}
\alias{get_data3d_data}
\alias{put_data3d_value}
\alias{put_data3d_data}
\alias{read_data3d_value}
\alias{write_data3d_value}
\title{Read and write Data3D data}
\usage{
get_data3d_value(x, z, dimension, db = default_db())

get_data3d_data(x, z, dimension, db = default_db())

put_data3d_value(value, x, z, dimension, db = default_db())

put_data3d_data(values, x, z, dimension, db = default_db())

read_data3d_value(rawvalue)

write_data3d_value(value)
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{value}{A Data3D value.}

\item{values}{A (named) list of Data3D values. If \code{x} is missing, the names
of \code{values} will be taken as the keys.}

\item{rawvalue}{A raw vector.}
}
\value{
\code{get_data3d_value()} returns a Data3D value. \code{get_data3d_data()}
returns a named list of Data3D values. Data3D values are lists containing
two elements. The \code{height_map} element is a 16x16 matrix containing height
data. The \code{biome_map} element is a 16x384x16 array containing biome data.
}
\description{
Data3D data (tag 43) stores information about surface heights and biomes in a
chunk.
}
\details{
\itemize{
\item \code{get_data3d_value()} and \code{get_data3d_data()} load Data3D
data from \code{db}. \code{get_data3d_value()} loads data for a single chunk,
and \code{get_data3d_data()} loads data for multiple chunks.
\item \code{put_data3d_value()} and \code{put_data3d_data()} store Data3D
data into \code{db}.
\item \code{write_data3d_value()} encodes Data3D data into a raw vector.
\code{read_data3d_value()} decodes binary Data3D data.
}
}
\seealso{
Data2D
}
