% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-tables.R
\name{export_table}
\alias{export_table}
\alias{import_table}
\title{Export data frame to different common formats}
\usage{
export_table(
  x,
  file,
  format = c("auto", "csv", "csv.zip", "tsv", "h5", "fst", "json", "rds", "yaml"),
  ...
)

import_table(
  file,
  format = c("auto", "csv", "csv.zip", "tsv", "h5", "fst", "json", "rds", "yaml"),
  ...
)
}
\arguments{
\item{x}{data table to be saved to \code{file}}

\item{file}{file to store the data}

\item{format}{data storage format, default is \code{'auto'} (infer from the
file extension); other choices are \code{'csv'}, \code{'csv.zip'}, \code{'h5'},
\code{'fst'}, \code{'json'}, \code{'rds'}, \code{'yaml'}}

\item{...}{parameters passed to other functions}
}
\value{
The normalized path for \code{export_table}, and a
\code{\link[data.table]{data.table}} for \code{import_table}
}
\description{
Stores and load data in various of data format. See 'Details' for limitations.
}
\details{
The format \code{'rds'}, \code{'h5'}, \code{'fst'}, \code{'json'}, and
\code{'yaml'} try to preserve the first-level column attributes. Factors
will be preserved in these formats. Such property does not exist in
\code{'csv'}, \code{'csv.zip'} formats.

Open-data formats are \code{'h5'}, \code{'csv'}, \code{'csv.zip'},
\code{'json'}, \code{'yaml'}. These formats require the table elements to
be native types (numeric, character, factor, etc.).

\code{'rds'}, \code{'h5'}, and \code{'fst'} can store large data sets.
\code{'fst'} is the best choice is performance and file size are the major
concerns. \code{'rds'} preserves all the properties of the table.
}
\examples{

x <- data.table::data.table(
  a = rnorm(10),
  b = letters[1:10],
  c = 1:10,
  d = factor(LETTERS[1:10])
)

f <- tempfile(fileext = ".csv.zip")

export_table(x = x, file = f)

y <- import_table(file = f)

str(x)
str(y)

# clean up
unlink(f)


}
