% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{equivalent_bs_vola_to_jump}
\alias{equivalent_bs_vola_to_jump}
\title{Find straight Black-Scholes volatility equivalent to jump process with a given default risk}
\usage{
equivalent_bs_vola_to_jump(
  jump_process_vola,
  time,
  const_short_rate = 0,
  const_default_intensity = 0,
  discount_factor_fcn = function(T, t, ...) {
     exp(-const_short_rate * (T - t))
 },
  survival_probability_fcn = function(T, t, ...) {
     exp(-const_default_intensity * (T
    - t))
 },
  dividends = NULL,
  borrow_cost = 0,
  dividend_rate = 0,
  relative_tolerance = 1e-06,
  max.iter = 100
)
}
\arguments{
\item{jump_process_vola}{Volatility of default-free process}

\item{time}{Time to expiration of associated option contracts}

\item{const_short_rate}{A constant to use for the instantaneous interest rate in case \code{discount_factor_fcn}
is not given}

\item{const_default_intensity}{A constant to use for the instantaneous default intensity in case \code{survival_probability_fcn}
is not given}

\item{discount_factor_fcn}{A function for computing present values to
time \code{t} of various cashflows occurring during this timestep, with
arguments \code{T}, \code{t}}

\item{survival_probability_fcn}{(Implied argument) A function for probability of survival, with
arguments \code{T}, \code{t} and \code{T>t}.}

\item{dividends}{A \code{data.frame} with columns \code{time}, \code{fixed},
and \code{proportional}.  Dividend size at the given \code{time} is
then expected to be equal to \code{fixed + proportional * S / S0}.  Fixed
dividends will be converted to proportional for purposes of this algorithm.}

\item{borrow_cost}{A continuous rate for stock borrow costs}

\item{dividend_rate}{A continuous accumulation rate for the stock, affecting the drift}

\item{relative_tolerance}{Relative tolerance in instrument price defining the root-finder halting condition}

\item{max.iter}{Maximum number of root-finder iterations allowed}
}
\value{
A scalar defaultable volatility of an option
}
\description{
Find Black-Scholes volatility based on known
  interest rates and hazard rates, using
  an at-the-money put option at the given tenor to set the standard price.
}
\seealso{
Other Implied Volatilities: 
\code{\link{american_implied_volatility}()},
\code{\link{equivalent_jump_vola_to_bs}()},
\code{\link{fit_variance_cumulation}()},
\code{\link{implied_jump_process_volatility}()},
\code{\link{implied_volatilities}()},
\code{\link{implied_volatilities_with_rates_struct}()},
\code{\link{implied_volatility}()},
\code{\link{implied_volatility_with_term_struct}()}

Other Equity Independent Default Intensity: 
\code{\link{american}()},
\code{\link{american_implied_volatility}()},
\code{\link{black_scholes_on_term_structures}()},
\code{\link{blackscholes}()},
\code{\link{equivalent_jump_vola_to_bs}()},
\code{\link{implied_volatilities}()},
\code{\link{implied_volatilities_with_rates_struct}()},
\code{\link{implied_volatility}()},
\code{\link{implied_volatility_with_term_struct}()}
}
\concept{Equity Independent Default Intensity}
\concept{Implied Volatilities}
