% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_rtwig.R
\name{run_rtwig}
\alias{run_rtwig}
\title{Run Real Twig}
\usage{
run_rtwig(
  filename,
  twig_radius,
  metrics = TRUE,
  version = NULL,
  smooth = TRUE,
  standardise = FALSE,
  broken_branch = TRUE,
  ...
)
}
\arguments{
\item{filename}{file path to QSM (.mat, .csv, .json)}

\item{twig_radius}{Twig radius in millimeters}

\item{metrics}{Calculate tree metrics. Defaults to TRUE.}

\item{version}{If using a specific version of TreeQSM, the user can specify
the version (e.g. 2.4.1, 2.0, etc.).}

\item{smooth}{Defaults to TRUE if using TreeQSM. Can be set to FALSE.}

\item{standardise}{Standardise QSM cylinder data.
Defaults to FALSE, but can be set to TRUE.}

\item{broken_branch}{Enable or disable the broken branch filter.
Defaults to TRUE.}

\item{...}{Additional arguments allowing standardise and standardize to be
used as synonyms.}
}
\value{
Returns cylinder data frame or list if metrics is true.
}
\description{
Run the Real Twig correction and calculate tree metrics for
supported QSM formats.
}
\examples{

## TreeQSM
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- run_rtwig(file, twig_radius = 4.23)
str(qsm$cylinder)

}
